PROCESSOR	PIC16F84A
INCLUDE		<P16F84A.INC>
RADIX		HEX
ORG		0000h
GOTO	MAIN
ORG		0004h
GOTO	ISR

;*******************************************************************************************
;	24  HOUR DIGITAL CLOCK
;	www.electronicecircuits.com
;********************************************************************************************

CBLOCK	0Ch
S1
S10
M1
M10
H1
H10
DEL
DEL0
DEL01
DEL02
WHAT
QSTAT

ENDC
#DEFINE	DP PORTB,0   ; PIN NO 06  DECIMA POINT

	
DELAY01	DECFSZ	DEL,1
			GOTO	$-.1
			CLRF	PORTB
			RETURN
DELAY02	MOVLW	.2
			MOVWF	DEL01
			DECFSZ	DEL01,1
			GOTO	$-.1
			RETURN

; SEVEN SEGMENT DISPLAY CONNECTING  TABLE	
TABLE	ADDWF	PCL,1;				hgfedcba  segments
		RETLW	B'01111110'		;0 ;
		RETLW	B'00001100'		;1
		RETLW	B'10110110'		;2
		RETLW	B'10011110'		;3
		RETLW	B'11001100'		;4
		RETLW	B'11011010'		;5
		RETLW	B'11111010'		;6
		RETLW	B'00001110'		;7
		RETLW	B'11111110'		;8
		RETLW	B'11011110'		;9
		
SCAN	MOVLW	B'00000001'  	;SEGMENT 01
		MOVWF	PORTA
		MOVF	M1,0
		CALL	TABLE
		MOVWF	PORTB
		CALL	DELAY01
		MOVLW	B'00000010'	;SEGMENT 02
		MOVWF	PORTA
		MOVF	M10,0
		CALL	TABLE
		MOVWF	PORTB	
		CALL	DELAY01	
		MOVLW	B'00000100'	;SEGMENT 03
		MOVWF	PORTA
		MOVF	H1,0
		CALL	TABLE
		MOVWF	PORTB	
		CALL	DELAY01
		MOVLW	B'00001000'	;SEGMENT 04
		MOVWF	PORTA
		MOVF	H10,0
		CALL	TABLE
		MOVWF	PORTB
		CALL	DELAY01
		RETURN
		
INCR	INCF	S1,1
		MOVF	S1,0
		BCF		STATUS,Z
		XORLW	.10
		BTFSS	STATUS,Z
		RETURN
		CLRF	S1
		INCF	S10,1
		MOVF	S10,0
		BCF		STATUS,Z
		XORLW	.6
		BTFSS	STATUS,Z
		RETURN
		CLRF	S10
INCR_SM		INCF	M1,1
				MOVF	M1,0
				BCF		STATUS,Z
				XORLW	.10
				BTFSS	STATUS,Z
				RETURN
				CLRF	M1
				INCF	M10,1
				MOVF	M10,0
				BCF		STATUS,Z
				XORLW	.6
				BTFSS	STATUS,Z
				RETURN
				CLRF	M10

INCR_SH	INCF	H1
			SWAPF	H10,0
			ADDWF	H1,0
			BCF		STATUS,Z
			XORLW	24h
			BTFSS	STATUS,Z
			GOTO	$+4
			CLRF	H1
			CLRF	H10
			RETURN
			MOVF	H1,0
			BCF		STATUS,Z
			XORLW	.10
			BTFSS	STATUS,Z
			RETURN
			CLRF	H1
			INCF	H10,1
			RETURN
ISR		BCF		INTCON,GIE
		MOVWF	WHAT
		SWAPF	STATUS,0
		MOVWF	QSTAT
		BCF		INTCON,T0IF
		MOVLW	.5
		MOVWF	TMR0
		INCF	DEL0,1
		MOVF	DEL0,0
		ANDLW	B'01111111'
		BCF		STATUS,Z
		XORLW	.125
		BTFSS	STATUS,Z
		GOTO	LABLE
		BTFSS	DEL0,7
		GOTO	$+.5
		CLRF	DEL0
		CALL	INCR
		GOTO	LABLE
		GOTO	LABLE
		BTFSS	DEL0,7
		GOTO	$+.5
		CLRF	DEL0
		BCF	DP		; DECIMAL  POINT
		CALL	INCR
		GOTO	LABLE
		MOVLW	.200   ; DECIMAL POINT DELAY SETTING
		MOVWF	DEL0	;DECIMAL POINT
		BSF	DP


LABLE		SWAPF	QSTAT,0
			MOVWF	STATUS
			SWAPF	WHAT,1
			SWAPF	WHAT,0
			BSF		INTCON,GIE
			RETFIE
		
KEY		BSF		OPTION_REG,7
			BCF		INTCON,GIE
			BSF		STATUS,RP0
			MOVLW	B'11101111'
			MOVWF	TRISB
			BCF		STATUS,RP0
			MOVLW	B'00000000'
			MOVWF	PORTB
			CALL	DELAY02
;  **********************************
SM1	BTFSC	PORTB,1  ; SET MINITUS
		GOTO	SH1
		CALL	INCR_SM
		GOTO	KEYX
;***********************************

;***********************************
SH1	CALL	DELAY02  
		BTFSC	PORTB,2  ;   SET HOUR
		GOTO	KEYDE
		CALL	INCR_SH
;***********************************


KEYX		BSF		STATUS,RP0
			CLRF	TRISB
			BCF		STATUS,RP0
			MOVLW	.100
			MOVWF	DEL02
			CALL	SCAN
			DECFSZ	DEL02,1
			GOTO	$-.2
			BSF		INTCON,GIE
			BCF		OPTION_REG,7
			RETURN
		
KEYDE	BSF		STATUS,RP0
			CLRF		TRISB
			BCF		STATUS,RP0
			BSF		INTCON,GIE
			BCF		OPTION_REG,7
			RETURN
		
				
			
MAIN	CLRF	S1
		CLRF	S10
		CLRF	M1
		CLRF	M10
		CLRF	H1
		CLRF	H10
		CLRF	DEL
		CLRF	DEL0
		CLRF	DEL01
		CLRF	DEL02
		CLRF	WHAT
		CLRF	QSTAT
		BSF	STATUS,RP0
		CLRF	TRISB
		CLRF	TRISA
		MOVLW	B'00000011'
		MOVWF	OPTION_REG
		BSF		INTCON,T0IE
		BSF		INTCON,GIE
		BCF		STATUS,RP0
		CALL	SCAN
		CALL	KEY
		GOTO	$-.2	
				
ORG		2007h
DATA	3FF1h
END
	
